(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5819,        235]*)
(*NotebookOutlinePosition[      6749,        266]*)
(*  CellTagsIndexPosition[      6705,        262]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Check Linear Theory"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The equation being studied is: ",
  StyleBox["y'[x]+p[x]*y[x] == q[x]", "Input"],
  ".  \nIn this notebook we duplicate in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " the two problems which show what the operator \n",
  StyleBox["L[x, y] = y'[x]+p[x]*y[x]", "Input"],
  "  does to the null space and to the particular solution. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["The operator", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], 
        "+", \(p[x]\ y[x]\)}]}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{\(p[x]\ y[x]\), "+", 
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["An Integrating Factor"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(mu[x_] = Exp[\[Integral]p[x] \[DifferentialD]x]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[ExponentialE]\^\(\[Integral]p[x] \[DifferentialD]x\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The null space"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(uc[x_] = C\/mu[x]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(C\ \[ExponentialE]\^\(-\(\[Integral]p[x] \[DifferentialD]x\)\)\)], \
"Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A particular solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(yp[x_] = \(\[Integral]\(mu[x]\ q[x]\) \[DifferentialD]x\)\/mu[x]\)], \
"Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[ExponentialE]\^\(-\(\[Integral]p[x] \[DifferentialD]x\)\)\ \(\
\[Integral]\(\[ExponentialE]\^\(\[Integral]p[x] \[DifferentialD]x\)\ q[
              x]\) \[DifferentialD]x\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check the null space"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, uc]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check the particular solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, yp]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(q[x]\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check the general solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Here is the general solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Y[x_] = uc[x] + yp[x]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(C\ \[ExponentialE]\^\(-\(\[Integral]p[x] \[DifferentialD]x\)\) + \
\[ExponentialE]\^\(-\(\[Integral]p[x] \[DifferentialD]x\)\)\ \(\[Integral]\(\
\[ExponentialE]\^\(\[Integral]p[x] \[DifferentialD]x\)\ q[
                x]\) \[DifferentialD]x\)\)], "Output"]
}, Closed]],

Cell[TextData["check it."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, Y]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(q[x]\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initialization"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Clear[p, q, y, mu, uc, yp, L]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{529, 607},
WindowMargins->{{76, Automatic}, {Automatic, 8}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 97, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1876, 57, 423, 11, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2324, 72, 79, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2428, 78, 245, 7, 27, "Input"],
Cell[2676, 87, 168, 4, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[2893, 97, 98, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3016, 103, 106, 2, 41, "Input"],
Cell[3125, 107, 88, 1, 31, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3262, 114, 91, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3378, 120, 76, 2, 44, "Input"],
Cell[3457, 124, 98, 2, 31, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3604, 132, 98, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3727, 138, 125, 3, 48, "Input"],
Cell[3855, 143, 209, 3, 41, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4113, 152, 97, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4235, 158, 77, 2, 27, "Input"],
Cell[4315, 162, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4399, 169, 106, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4530, 175, 77, 2, 27, "Input"],
Cell[4610, 179, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4697, 186, 103, 2, 36, "Section",
  Evaluatable->False],
Cell[4803, 190, 103, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4931, 196, 80, 2, 27, "Input"],
Cell[5014, 200, 278, 4, 41, "Output"]
}, Closed]],
Cell[5307, 207, 83, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5415, 213, 76, 2, 27, "Input"],
Cell[5494, 217, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5581, 224, 91, 2, 36, "Section",
  Evaluatable->False],
Cell[5675, 228, 116, 3, 27, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

